#include <iostream>
#include <vector>
#include <algorithm>
#include <limits>

using namespace std;

struct Point {
    int x, y;
};
int presek(Point O, Point A, Point B) {
    return (A.x-O.x) * (B.y-O.y)-(A.y-O.y)*(B.x-O.x);
}
vector<Point> KonveksniDeo(vector<Point>& points) {
    int n=points.size();
    if(n<3) 
    return points;

    vector<Point> deo;
    sort(points.begin(), points.end(), [](Point a, Point b) {
        return (a.x==b.x) ? (a.y<b.y) : (a.x<b.x);
        });
    for (int i=0; i<n; i++) {
        while (deo.size()>=2 and presek(deo[deo.size()-2], deo.back(), points[i])<=0) {
            deo.pop_back();
        }
        deo.push_back(points[i]);
    }
    int VelicinaDela = deo.size();
    for (int i=n-2; i>=0; i--) {
        while (deo.size() > VelicinaDela and presek(deo[deo.size()-2], deo.back(), points[i])<=0) {
            deo.pop_back();
        }
        deo.push_back(points[i]);
    }

    deo.pop_back();
    return deo;
}
double AlgoritamPertle(const vector<Point>& deo)
{
    double povrsina = 0;
    int n = deo.size();
    for (int i=0; i<n; i++)
    {
        povrsina+=(deo[i].x*deo[(i+1)%n].y)-(deo[i].y*deo[(i+1)%n].x);
    }
    return abs(povrsina) / 2.0;
}

int main() {
    int n;
    cin >> n;
    vector<Point> tacke;
    for (int i=0; i<n; i++) {
        Point p;
        cin >> p.x >> p.y;
        if (p.x%2==0 and p.y%2==0)
        {
            tacke.push_back(p);
        }
    }

    double NajmanjaPovrsina = numeric_limits<double>::max();
    vector<Point> NajmanjiDeo;
    for (int i = 0; i < tacke.size(); i++) {
        vector<Point> temptacke;
        for (int j = 0; j < tacke.size(); j++) {
            if (j != i) {
                temptacke.push_back(tacke[j]);
            }
        }
        vector<Point> deo = KonveksniDeo(temptacke);
        double povrsina = AlgoritamPertle(deo);
        if (povrsina < NajmanjaPovrsina) {
            NajmanjaPovrsina = povrsina;
            NajmanjiDeo = deo;
        }
    }
    cout << NajmanjaPovrsina << endl;

    return 0;
}